'==========================================================================
' NAME: ConfigPOP3.vbs
'
' COMMENT: Contains procedures to configure POP3 and SMTP settings
'
'***********************************************************************
' THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
' PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
' EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
' WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
' AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
' 
' Copyright (c) Microsoft Corporation.  All rights reserved.
'***********************************************************************
'==========================================================================


Public sub ConfigPOP3(nAuthMethod,nPort,strMailRoot)
'===================================================================
'	NAME: ConfigPOP3
'	IN: nAuthMethod - Authenitcation method
'		nPort - Server Port for Pop 3
'		strMailRoot - Mail root
'===================================================================
	Dim strCmd
	Dim strWinPop
	Dim oExec
	
	strCmd = "cmd.exe /C winpop set "
	'first set the authentication method to local windows accounts
	strWinPop = strCmd & "authentication " & nAuthMethod
	Set oExec = WshShell.Exec(strWinPop)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	'Set port number
	strWinPop = strCmd & "port " & nPort
	Set oExec = WshShell.Exec(strWinPop)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	'Set Mail Root
	strWinPop = strCmd & "mailroot " & strMailRoot
	Set oExec = WshShell.Exec(strWinPop)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
	'Require SPA
	strWinPop = strCmd & "sparequired 1"
	Set oExec = WshShell.Exec(strWinPop)
	Do While Not oExec.StdOut.AtEndOfStream
		write oLogFile,oExec.StdOut.ReadLine,Err_INFO,bDebug
	Loop
End sub
